/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import java.util.function.BiConsumer;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class SFMDirections {
    public static final Direction[] DIRECTIONS_WITHOUT_NULL = Direction.values();
    public static final Direction[] DIRECTIONS_WITH_NULL = new Direction[]{null, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN};

    public record NullableDirectionEnumMap<T>(T[] buckets) {
        public NullableDirectionEnumMap() {
            this(new Object[DIRECTIONS_WITH_NULL.length]);
        }

        public boolean containsKey(@Nullable Direction direction) {
            return this.buckets[this.keyFor(direction)] != null;
        }

        public void forEach(BiConsumer<Direction, T> callback) {
            for (Direction direction : DIRECTIONS_WITH_NULL) {
                T value = this.buckets[this.keyFor(direction)];
                if (value == null) continue;
                callback.accept(direction, (Direction)value);
            }
        }

        public void remove(@Nullable Direction direction) {
            this.buckets[this.keyFor((Direction)direction)] = null;
        }

        public boolean isEmpty() {
            for (T bucket : this.buckets) {
                if (bucket == null) continue;
                return false;
            }
            return true;
        }

        public void put(@Nullable Direction direction, T value) {
            this.buckets[this.keyFor((Direction)direction)] = value;
        }

        @Nullable
        public T get(@Nullable Direction direction) {
            return this.buckets[this.keyFor(direction)];
        }

        public int size() {
            int count = 0;
            for (T bucket : this.buckets) {
                if (bucket == null) continue;
                ++count;
            }
            return count;
        }

        private int keyFor(@Nullable Direction direction) {
            return direction == null ? 0 : direction.ordinal() + 1;
        }
    }
}

